/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.requests;

import com.ibm.hwmca.base.rsf.BaseRemoteSupportFacility;
import com.ibm.hwmca.base.rsf.requests.BaseRsfRequest;
import com.ibm.hwmca.base.rsf.requests.BaseRsfRequestErrorIds;
import com.ibm.hwmca.base.rsf.util.FtService;
import com.ibm.hwmca.base.rsf.util.FtsException;
import com.ibm.hwmca.base.rsf.util.RqService;
import com.ibm.hwmca.base.rsf.util.RqsException;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.MicrocodeLogAttributes;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.rbf.RbfManager;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestType;
import com.ibm.hwmca.fw.rcs.conndata.AccountInfo;
import com.ibm.hwmca.fw.rcs.path.RcsPath;
import com.ibm.hwmca.fw.rcs.sas.SysInfo;
import com.ibm.hwmca.fw.rsf.RsfRequestBody;
import com.ibm.hwmca.fw.rsf.RsfStatusEvent;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;

public class BaseRsfRequestImpl
extends RbfRequest
implements BaseRsfRequestErrorIds {
    private static final String TRACE_MASKT = "XRSFRQIT";
    private static final String TRACE_MASKF = "XRSFRQIF";
    private static final String TRACE_MASKD = "XRSFRQID";
    private static final String mclStatusMethod = "mclRetrieveStatus";
    private static final String newMclMethod = "nextMclRetrieved";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "RsfReqImpl");
    private static MicrocodeLogAttributes infoLog = MicrocodeLogAttributes.INFO_LOG;
    private static MicrocodeLogAttributes infoLogDisplayError = new MicrocodeLogAttributes(false, false, true, true, true, true, false, 0);
    protected Date initDate;
    private int priority = 2;
    private BaseRsfRequest rsfRequest;
    private boolean containsRsfRequest;
    private String resultProcessor = null;
    private SysInfo owningCredentials = null;
    private int credentialTries = 1;
    private String rsfId;
    private String platform;
    private HashMap eventMap;
    private RcsPath path;
    private AccountInfo acctInfo;
    protected boolean legacy;

    public BaseRsfRequestImpl(PersistentData data) throws PersistenceException {
        super(((Persistent)data).parentData);
        this.resultProcessor = ((Persistent)data).resultProcessor;
        this.initDate = ((Persistent)data).initDate;
        this.priority = ((Persistent)data).priority;
        this.containsRsfRequest = ((Persistent)data).containsRsfRequest;
        this.owningCredentials = ((Persistent)data).owningCredentials;
        this.credentialTries = ((Persistent)data).credentialTries;
        this.rsfId = ((Persistent)data).rsfId;
        this.platform = ((Persistent)data).platform;
        if (this.containsRsfRequest) {
            this.rsfRequest = new BaseRsfRequest(this);
        }
        if (((Persistent)data).version < 1) {
            this.eventMap = new HashMap();
            this.legacy = false;
        } else {
            this.eventMap = ((Persistent)data).eventMap;
            this.legacy = ((Persistent)data).legacy;
        }
    }

    protected BaseRsfRequestImpl(RbfRequestType rbfType, RsfRequestBody rsfContent, LocalizableText shortDescription, String resultProcessorName, boolean persist, int scope) throws NullPointerException {
        super(rbfType, shortDescription, resultProcessorName, (Object)rsfContent, persist, scope);
        this.initDate = new Date();
        this.setSource();
        this.rsfId = this.getIdentifier().toString();
        this.eventMap = new HashMap();
        this.legacy = false;
    }

    public BaseRsfRequestImpl(RbfRequestType rbfType, RsfRequestBody rsfContent, LocalizableText shortDescription, String resultProcessorName) throws NullPointerException {
        super(rbfType, shortDescription, resultProcessorName, rsfContent);
        this.initDate = new Date();
        this.setSource();
        this.rsfId = this.getIdentifier().toString();
        this.eventMap = new HashMap();
        this.legacy = false;
    }

    public BaseRsfRequestImpl copyRequest() {
        RbfRequestType oldRequestType = this.getType();
        RsfRequestBody oldContent = (RsfRequestBody)this.getBody();
        LocalizableText oldShortDescription = this.getShortDescription();
        String oldResultProcessorName = this.getResultProcessor();
        boolean oldPersist = this.isPersistent();
        int oldScope = this.getScope();
        Set handlerSet = this.getHandlerSubset();
        BaseRsfRequestImpl result = new BaseRsfRequestImpl(oldRequestType, oldContent, oldShortDescription, oldResultProcessorName, oldPersist, oldScope);
        if (handlerSet != null) {
            result.setHandlerSubset(handlerSet);
        }
        result.resultProcessor = this.resultProcessor;
        result.initDate = this.initDate;
        result.priority = this.priority;
        result.containsRsfRequest = this.containsRsfRequest;
        result.owningCredentials = this.owningCredentials;
        result.rsfRequest = this.rsfRequest;
        result.credentialTries = this.credentialTries;
        result.rsfId = this.rsfId;
        result.platform = this.platform;
        result.eventMap = this.eventMap;
        result.legacy = this.legacy;
        return result;
    }

    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.parentData = super.getPersistentData();
        result.resultProcessor = this.resultProcessor;
        result.initDate = this.initDate;
        result.priority = this.priority;
        result.containsRsfRequest = this.containsRsfRequest;
        result.owningCredentials = this.owningCredentials;
        result.credentialTries = this.credentialTries;
        result.rsfId = this.rsfId;
        result.platform = this.platform;
        result.eventMap = this.eventMap;
        result.legacy = this.legacy;
        return result;
    }

    public BaseRsfRequest getRsfRequest() {
        return this.rsfRequest;
    }

    public void setRsfRequest(BaseRsfRequest baseRsfRequest) {
        if (baseRsfRequest != null) {
            this.rsfRequest = baseRsfRequest;
            this.containsRsfRequest = true;
        }
    }

    public void addStatusListener(String eventType, String className) {
        Trace.trace(TRACE_MASKT, "<> BaseRsfRequestImpl::addStatusListener()");
        this.eventMap.put(eventType, className);
    }

    public String getRsfResultProcessor() {
        return this.resultProcessor;
    }

    public String getId() {
        return this.rsfId;
    }

    public void setRsfResultProcessor(String rsfResultProcessor) {
        this.resultProcessor = rsfResultProcessor;
    }

    public boolean shouldBeHandled() {
        Trace.trace(TRACE_MASKT, "-> BaseRsfRequestImpl::shouldBeHandled() " + this.getIdentifier());
        if (this.containsRsfRequest) {
            if (this.rsfRequest == null) {
                Trace.trace(TRACE_MASKF, "BaseRsfRequestImpl.shouldBeHandled - no BaseRsfRequest");
                this.rsfRequest = (BaseRsfRequest)BaseRemoteSupportFacility.getRsf().getRequest(this.getIdentifier().toString());
                if (this.rsfRequest == null) {
                    Trace.trace(TRACE_MASKF, "BaseRsfRequestImpl.shouldBeHandled - can't reconstitute BaseRsfRequest");
                    return false;
                }
            }
            this.rsfRequest.beginningHandling();
        } else {
            Trace.trace(TRACE_MASKF, "BaseRsfRequestImpl.shouldBeHandled: called for unknown rsf request");
        }
        Trace.trace(TRACE_MASKT, "<- BaseRsfRequestImpl::shouldBeHandled() " + this.getIdentifier());
        return true;
    }

    public Object executeProgram(String programName, String[] execParms) {
        Trace.trace(TRACE_MASKF, "BaseRsfRequestImpl.executeProgram for " + programName);
        if (programName == null) {
            return "Program name unspecified or incorrect";
        }
        String utilMethod = programName;
        String[] parms = execParms;
        int nameLength = programName.length();
        if (nameLength > 3 && programName.substring(nameLength - 3, nameLength).equalsIgnoreCase("exe")) {
            utilMethod = "processExecute";
            int numParms = 0;
            if (execParms != null) {
                numParms = execParms.length;
            }
            parms = new String[numParms + 1];
            parms[0] = programName;
            for (int i = 0; i < numParms; ++i) {
                parms[i + 1] = execParms[i];
            }
        } else {
            Trace.trace(TRACE_MASKF, "BaseRsfRequestImpl::executeProgram() not supported for non-exe program");
        }
        Object results = this.executeMethod("com.ibm.hwmca.base.rsf.util.RsfExecUtils", utilMethod, parms);
        Trace.trace(TRACE_MASKT, "<- BaseRsfRequestImpl::executeProgram()");
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private Object executeMethod(String className, String methodName, Object parms) {
        void var4_4;
        Object results;
        Trace.trace(TRACE_MASKT, "-> BaseRsfRequestImpl::executeMethod() " + methodName + " in " + className);
        if (this.isLocalRequest() && !BaseRemoteSupportFacility.testFlag.equals("TEST_REMOTE_EXEC")) {
            results = RqService.executeLocalMethod(className, methodName, parms);
        } else {
            try {
                results = RqService.getRqService().executeProgram(className, methodName, parms, this.getOriginMachine());
                Trace.trace(TRACE_MASKF, "Executed '" + methodName + "' :returnVal = " + results);
            }
            catch (RqsException e) {
                Trace.trace(TRACE_MASKF, "BaseRsfRequestImpl.executeProgram: RqsException executing " + methodName);
                Trace.trace(TRACE_MASKF, e);
                return "Remote execute error ";
            }
        }
        return var4_4;
    }

    public boolean executeProgram(String programName) {
        Trace.trace(TRACE_MASKF, "-> BaseRsfRequestImpl.executeProgram no parms");
        boolean result = false;
        if (programName != null && ((String)this.executeProgram(programName, null)).equals("Successful remote execute")) {
            result = true;
        }
        Trace.trace(TRACE_MASKT, "<- BaseRsfRequestImpl.executeProgram no parms");
        return result;
    }

    public String getFilePath(String filename) {
        Trace.trace(TRACE_MASKF, "BaseRsfRequestImpl.getFilePath: returns null in super class implementation");
        return null;
    }

    public void completedMcf(int filesDone, int totalFiles) {
        Trace.trace(TRACE_MASKT, "-> BaseRsfRequestImpl::completedMcf()");
        String eventId = "Mcl Downloaded";
        String className = (String)this.eventMap.get(eventId);
        if (className == null) {
            Trace.trace(TRACE_MASKT, "<- BaseRsfRequestImpl::completedMcf() MCL_DOWNLOADED event not registered");
            return;
        }
        RsfStatusEvent event = new RsfStatusEvent(eventId);
        event.putAttribute("Mcl files downloaded", Integer.toString(filesDone));
        event.putAttribute("Mcl files", Integer.toString(totalFiles));
        String[] parms = new String[]{Integer.toString(filesDone), Integer.toString(totalFiles)};
        Object result = this.executeMethod(className, "rsfStatusUpdate", event);
        Trace.trace(TRACE_MASKT, "<- BaseRsfRequestImpl::completedMcf() with result=" + result);
    }

    public void completedBlock(long bytesDone, long totalBytes) {
        Trace.trace(TRACE_MASKT, "-> BaseRsfRequestImpl::completedBlock()");
        String eventId = "Block Downloaded";
        String className = (String)this.eventMap.get(eventId);
        if (className == null) {
            Trace.trace(TRACE_MASKT, "<- BaseRsfRequestImpl::completedBlock() BLOCK_DOWNLOADED event not registered");
            return;
        }
        RsfStatusEvent event = new RsfStatusEvent(eventId);
        event.putAttribute("Mcl bytes downloaded", Long.toString(bytesDone));
        event.putAttribute("Mcl bytes", Long.toString(totalBytes));
        Object result = this.executeMethod(className, "rsfStatusUpdate", event);
        Trace.trace(TRACE_MASKT, "<- BaseRsfRequestImpl::completedBlock() with result=" + result);
    }

    public void completedMcf(boolean callHomeCompleted) {
    }

    public boolean getFile(String localPathname, String remotePathname, boolean isRemoteFullyQualified) {
        String fullRemotePathname;
        Trace.trace(TRACE_MASKT, "-> BaseRsfRequestImpl::getFile()");
        if (isRemoteFullyQualified) {
            fullRemotePathname = remotePathname;
        } else {
            try {
                fullRemotePathname = RqService.getRqService().queryFileLocation(remotePathname, this.getOriginMachine());
                if (fullRemotePathname == null) {
                    Trace.trace(TRACE_MASKF, "BaseRsfRequestImpl.getFile: null returned from queryFileLocation for " + remotePathname + " using unqualified value");
                    fullRemotePathname = remotePathname;
                } else {
                    fullRemotePathname = fullRemotePathname + remotePathname;
                }
            }
            catch (RqsException e) {
                Trace.trace(TRACE_MASKF, "BaseRsfRequestImpl.getFile: exception from queryFileLocation");
                Trace.trace(TRACE_MASKF, e);
                fullRemotePathname = remotePathname;
            }
        }
        try {
            FtService.getFtService().get(this.getOriginMachine(), localPathname, fullRemotePathname);
        }
        catch (FtsException e) {
            Trace.trace(TRACE_MASKF, e);
            Trace.trace(TRACE_MASKT, "<- BaseRsfRequestImpl::getFile()");
            return false;
        }
        Trace.trace(TRACE_MASKT, "<- BaseRsfRequestImpl::getFile()");
        return true;
    }

    public boolean putFile(String localPathname, String remotePathname, boolean isRemoteFullyQualified) {
        String fullRemotePathname;
        Trace.trace(TRACE_MASKT, "-> BaseRsfRequestImpl::putFile()");
        if (isRemoteFullyQualified) {
            fullRemotePathname = remotePathname;
        } else {
            try {
                fullRemotePathname = RqService.getRqService().queryFileLocation(remotePathname, this.getOriginMachine());
                if (fullRemotePathname == null) {
                    Trace.trace(TRACE_MASKF, "BaseRsfRequestImpl.putFile: null returned from queryFileLocation for " + remotePathname + " using unqualified value");
                    fullRemotePathname = remotePathname;
                } else {
                    fullRemotePathname = fullRemotePathname + remotePathname;
                }
            }
            catch (RqsException e) {
                Trace.trace(TRACE_MASKF, "BaseRsfRequestImpl.putFile: exception from queryFileLocation");
                Trace.trace(TRACE_MASKF, e);
                fullRemotePathname = remotePathname;
            }
        }
        try {
            FtService.getFtService().put(this.getOriginMachine(), localPathname, fullRemotePathname);
        }
        catch (FtsException e) {
            Trace.trace(TRACE_MASKF, e);
            Trace.trace(TRACE_MASKT, "<- BaseRsfRequestImpl::putFile()");
            return false;
        }
        Trace.trace(TRACE_MASKT, "<- BaseRsfRequestImpl::putFile()");
        return true;
    }

    public int incrementCredentialTries() {
        return ++this.credentialTries;
    }

    public boolean isLocalRequest() {
        Trace.trace(TRACE_MASKD, "BaseRsfRequestImpl:: isLocalRequest() - Origin=" + this.getOriginMachine() + " Handler=" + this.getHandlingMachine());
        return this.getOriginMachine().equals(this.getHandlingMachine());
    }

    public String getRequestSource() {
        MachineId machine = this.getOriginMachine();
        String address = RbfManager.getRbfManager().getIpAddress(machine);
        return machine.getName() + "(" + address + ")";
    }

    public Date getInitiationTime() {
        return this.initDate;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int aPriority) {
        this.priority = aPriority;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public RcsPath getPath() {
        return this.path;
    }

    public void setAccountInfo(AccountInfo info) {
        this.acctInfo = info;
    }

    public AccountInfo getAccountInfo() {
        return this.acctInfo;
    }

    public void setPath(RcsPath path) {
        this.path = path;
    }

    private void setSource() {
    }

    public SysInfo getOwningCredentials() {
        return this.owningCredentials;
    }

    public void setOwningCredentials(SysInfo credentials) {
        this.owningCredentials = credentials;
    }

    private static void logInfo(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLog);
    }

    private static void logError(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLogDisplayError);
    }

    private static class Persistent
    implements PersistentData {
        PersistentData parentData;
        String resultProcessor;
        Date initDate;
        boolean containsRsfRequest;
        SysInfo owningCredentials;
        int priority;
        int credentialTries;
        String rsfId;
        String platform;
        HashMap eventMap;
        boolean legacy;
        int version = 1;
        private static final long serialVersionUID = 1L;

        private Persistent() {
        }
    }
}

